﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment
{
    public class SendBothLoginsToEcStep : FilterBase<CancelGroupAppointmentStateObject>
    {
        public override void Execute(CancelGroupAppointmentStateObject state)
        {

            if (!string.IsNullOrEmpty(state.ProUserDuz) && !string.IsNullOrEmpty(state.PatUserDuz))
                return;
            else if (state.ProEcRequest == null && !string.IsNullOrEmpty(state.PatUserDuz))
                return;
            else if (state.PatEcRequest == null && !string.IsNullOrEmpty(state.ProUserDuz))
                return;

            if (!string.IsNullOrEmpty(state.CancelAppointmentFakeResponseType))
            {
                if (state.ProEcRequest != null)
                    state.ProEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_userId = string.IsNullOrEmpty(state.ProUserDuz) ? "FAKE_ProviderLogin" : state.ProUserDuz;
                if (state.PatEcRequest != null)
                    state.PatEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_userId = string.IsNullOrEmpty(state.PatUserDuz) ? "FAKE_PatientLogin" : state.PatUserDuz;
                return;
            }

            var proLogin = new LoginRequest
            {
                side = Side.Provider
            };
            var patLogin = new LoginRequest
            {
                side = Side.Patient
            };

            if (string.IsNullOrEmpty(state.ProUserDuz))
                proLogin.Request = state.ProLoginRequest;
            else
                proLogin.userId = state.ProUserDuz;

            if (string.IsNullOrEmpty(state.PatUserDuz))
                patLogin.Request = state.PatLoginRequest;
            else
                patLogin.userId = state.PatUserDuz;

            var timer = new Stopwatch();
            timer.Start();
            Parallel.ForEach(new LoginRequest[] { patLogin, proLogin }, login =>
            {
                if (login.Request != null)
                    login.userId = VistaMapperHelper.GetViaLoginId(login.Request, login.side);
            });
            timer.Stop();
            state.EcProcessingTimeMs = (int)timer.ElapsedMilliseconds;

            if (state.ProEcRequest != null)
                state.ProEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_userId = proLogin.userId;
            if (state.PatEcRequest != null)
                state.PatEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_userId = patLogin.userId;
        }
    }
}
